//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSES 5
#define MAX_TIME 10

// Define the process structure
typedef struct Process {
    int process_id;
    int arrival_time;
    int execution_time;
    int waiting_time;
    int turnaround_time;
} Process;

// Function to compare processes
int compare(Process a, Process b) {
    return a.arrival_time - b.arrival_time;
}

// Function to calculate waiting time
void calculate_waiting_time(Process *process) {
    process->waiting_time = process->arrival_time - process->execution_time;
}

// Function to calculate turnaround time
void calculate_turnaround_time(Process *process) {
    process->turnaround_time = process->waiting_time + process->execution_time;
}

int main() {
    // Create an array of processes
    Process processes[MAX_PROCESSES] = {
        {1, 0, 5, 0, 0},
        {2, 2, 3, 0, 0},
        {3, 3, 4, 0, 0},
        {4, 4, 2, 0, 0},
        {5, 5, 6, 0, 0}
    };

    // Sort the processes based on arrival time
    qsort(processes, MAX_PROCESSES, sizeof(Process), compare);

    // Calculate waiting time and turnaround time for each process
    for (int i = 0; i < MAX_PROCESSES; i++) {
        calculate_waiting_time(&processes[i]);
        calculate_turnaround_time(&processes[i]);
    }

    // Print the processes
    for (int i = 0; i < MAX_PROCESSES; i++) {
        printf("Process ID: %d, Arrival Time: %d, Execution Time: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].arrival_time, processes[i].execution_time, processes[i].waiting_time, processes[i].turnaround_time);
    }

    return 0;
}