//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: retro
#include <stdio.h>
#include <stdlib.h>

#define N 5  // Size of the maze

// Function prototypes
void printMaze(char maze[N][N]);
int isSafe(char maze[N][N], int x, int y);
int findPath(char maze[N][N], int x, int y, int path[N][N]);
void printSolution(int path[N][N]);

int main() {
    // Sample maze, 1 = path, 0 = wall
    char maze[N][N] = {
        {1, 0, 0, 0, 0},
        {1, 1, 1, 0, 1},
        {0, 0, 1, 0, 1},
        {0, 1, 1, 1, 0},
        {0, 0, 0, 1, 1}
    };

    // 0s will represent the path
    int path[N][N] = { {0} };

    printf("Maze:\n");
    printMaze(maze);

    // Start from (0,0)
    if (findPath(maze, 0, 0, path)) {
        printf("\nSolved path:\n");
        printSolution(path);
    } else {
        printf("\nNo path found!\n");
    }

    return 0;
}

void printMaze(char maze[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf("%c ", maze[i][j] ? '1' : '0');
        }
        printf("\n");
    }
}

int isSafe(char maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y]);
}

int findPath(char maze[N][N], int x, int y, int path[N][N]) {
    // If (x, y) is the bottom right corner, mark it as part of the path
    if (x == N - 1 && y == N - 1) {
        path[x][y] = 1;
        return 1;
    }

    // Check if current position is safe
    if (isSafe(maze, x, y)) {
        // Mark x, y as part of the path
        path[x][y] = 1;

        // Move in the right direction (down)
        if (findPath(maze, x + 1, y, path))
            return 1;

        // Move in the right direction (right)
        if (findPath(maze, x, y + 1, path))
            return 1;

        // If none of the above movements work, BACKTRACK:
        path[x][y] = 0;
    }

    return 0;
}

void printSolution(int path[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf("%c ", path[i][j] ? '*' : ' ');
        }
        printf("\n");
    }
}