//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_Cars 20
#define RoadLength 100

typedef struct Car
{
    int position;
    int direction;
    int speed;
} Car;

void simulateTrafficFlow(Car cars[], int numCars)
{
    for (int i = 0; i < numCars; i++)
    {
        cars[i].position++;
        switch (cars[i].direction)
        {
            case 1:
                if (cars[i].position >= RoadLength)
                {
                    cars[i].direction = -1;
                }
                break;
            case -1:
                if (cars[i].position <= 0)
                {
                    cars[i].direction = 1;
                }
                break;
        }
    }
}

int main()
{
    srand(time(NULL));

    Car cars[MAX_Cars];
    for (int i = 0; i < MAX_Cars; i++)
    {
        cars[i].position = rand() % RoadLength;
        cars[i].direction = rand() % 2 - 1;
        cars[i].speed = rand() % 5 + 1;
    }

    simulateTrafficFlow(cars, MAX_Cars);

    for (int i = 0; i < MAX_Cars; i++)
    {
        printf("Car %d: position %d, direction %d, speed %d\n", i, cars[i].position, cars[i].direction, cars[i].speed);
    }

    return 0;
}