//Falcon-180B DATASET v1.0 Category: RAM usage monitor ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 100
#define MAX_PROCESS_NAME 50

typedef struct {
    char process_name[MAX_PROCESS_NAME];
    unsigned long long int ram_usage;
} process_t;

int num_processes = 0;
process_t processes[MAX_PROCESSES];

void add_process(char* name, unsigned long long int ram_usage) {
    if (num_processes >= MAX_PROCESSES) {
        printf("Error: Maximum number of processes reached\n");
        return;
    }

    strcpy(processes[num_processes].process_name, name);
    processes[num_processes].ram_usage = ram_usage;

    num_processes++;
}

void remove_process(int index) {
    if (index >= num_processes || index < 0) {
        printf("Error: Invalid process index\n");
        return;
    }

    num_processes--;

    for (int i = index; i < num_processes; i++) {
        strcpy(processes[i].process_name, processes[i+1].process_name);
        processes[i].ram_usage = processes[i+1].ram_usage;
    }
}

void update_ram_usage(int index, unsigned long long int new_ram_usage) {
    if (index >= num_processes || index < 0) {
        printf("Error: Invalid process index\n");
        return;
    }

    processes[index].ram_usage = new_ram_usage;
}

void print_processes() {
    printf("Processes:\n");

    for (int i = 0; i < num_processes; i++) {
        printf("%s - %llu bytes\n", processes[i].process_name, processes[i].ram_usage);
    }
}

int main() {
    add_process("Chrome", 500000000);
    add_process("Firefox", 400000000);
    add_process("VS Code", 300000000);

    print_processes();

    remove_process(1);

    print_processes();

    update_ram_usage(0, 600000000);

    print_processes();

    return 0;
}