//Falcon-180B DATASET v1.0 Category: Percolation Simulator ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 20
#define HEIGHT 10
#define DROPS 500

int board[HEIGHT][WIDTH]; // The board representing the grid of cells
int drops = 0; // The number of drops so far

void initBoard() {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            board[i][j] = 0; // Initialize all cells to be empty
        }
    }
}

void drawBoard() {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            if (board[i][j] == 1) {
                printf("X");
            } else {
                printf(".");
            }
        }
        printf("\n");
    }
}

int countNeighbors(int row, int col) {
    int count = 0;
    if (row > 0 && board[row - 1][col] == 1) {
        count++;
    }
    if (col > 0 && board[row][col - 1] == 1) {
        count++;
    }
    if (row < HEIGHT - 1 && board[row + 1][col] == 1) {
        count++;
    }
    if (col < WIDTH - 1 && board[row][col + 1] == 1) {
        count++;
    }
    return count;
}

void percolate(int row, int col) {
    if (row < 0 || row >= HEIGHT || col < 0 || col >= WIDTH) {
        return;
    }
    if (board[row][col] == 0) {
        board[row][col] = 1;
        drops++;
        if (drops == DROPS) {
            printf("The system has percolated after %d drops!\n", drops);
            exit(0);
        }
    }
}

int main() {
    srand(time(NULL));
    initBoard();
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            if (rand() % 2 == 1) {
                board[i][j] = 1;
            }
        }
    }
    int row = rand() % HEIGHT;
    int col = rand() % WIDTH;
    percolate(row, col);
    drawBoard();
    return 0;
}