//GPT-4o-mini DATASET v1.0 Category: Queue Implementation ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX 5

typedef struct {
    char name[50];
    double temperature;
    double pressure;
} Reaction;

typedef struct {
    Reaction reactions[MAX];
    int front;
    int rear;
} Queue;

// Function to initialize the queue
void initQueue(Queue* q) {
    q->front = -1;
    q->rear = -1;
}

// Function to check if the queue is full
int isFull(Queue* q) {
    return (q->rear + 1) % MAX == q->front;
}

// Function to check if the queue is empty
int isEmpty(Queue* q) {
    return q->front == -1;
}

// Function to enqueue a reaction
void enqueue(Queue* q, Reaction r) {
    if (isFull(q)) {
        printf("Queue is full. Cannot add reaction: %s\n", r.name);
        return;
    }
    if (isEmpty(q)) {
        q->front = 0;
    }
    q->rear = (q->rear + 1) % MAX;
    q->reactions[q->rear] = r;
    printf("Enqueued: %s at Temperature: %.2f°C, Pressure: %.2f atm\n", r.name, r.temperature, r.pressure);
}

// Function to dequeue a reaction
Reaction dequeue(Queue* q) {
    Reaction r = {"", 0, 0};
    if (isEmpty(q)) {
        printf("Queue is empty. Cannot dequeue.\n");
        return r;
    }
    r = q->reactions[q->front];
    if (q->front == q->rear) {
        q->front = -1;
        q->rear = -1;
    } else {
        q->front = (q->front + 1) % MAX;
    }
    printf("Dequeued: %s at Temperature: %.2f°C, Pressure: %.2f atm\n", r.name, r.temperature, r.pressure);
    return r;
}

// Function to display the queue
void displayQueue(Queue* q) {
    if (isEmpty(q)) {
        printf("Queue is empty.\n");
        return;
    }
    printf("Current reactions in the queue:\n");
    int i = q->front;
    while (1) {
        printf("Reaction: %s, Temperature: %.2f°C, Pressure: %.2f atm\n", q->reactions[i].name, q->reactions[i].temperature, q->reactions[i].pressure);
        if (i == q->rear) break;
        i = (i + 1) % MAX;
    }
}

// Main function to simulate the chemical reactions queue
int main() {
    Queue q;
    initQueue(&q);
    
    // Sample reactions
    Reaction r1 = {"Hydrogen Combustion", 1500.0, 1.5};
    Reaction r2 = {"Catalytic Cracking", 350.0, 2.0};
    Reaction r3 = {"Photosynthesis", 25.0, 1.0};
    Reaction r4 = {"Thermal Decomposition", 500.0, 1.2};
    Reaction r5 = {"Fermentation", 30.0, 0.5};
    Reaction r6 = {"Synthesis of Ammonia", 200.0, 3.0};

    enqueue(&q, r1);
    enqueue(&q, r2);
    enqueue(&q, r3);
    enqueue(&q, r4);
    enqueue(&q, r5);
    enqueue(&q, r6); // This will show queue full
    
    displayQueue(&q);
    
    dequeue(&q);
    dequeue(&q);
    
    displayQueue(&q);
    
    enqueue(&q, r6); // Now we can enqueue it

    displayQueue(&q);

    return 0;
}