//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

// Structure to represent a candidate
struct candidate {
    char name[50];
    int votes;
};

// Structure to represent a voter
struct voter {
    char name[50];
    int voted;
};

// Array of candidates
struct candidate candidates[MAX_CANDIDATES];

// Array of voters
struct voter voters[MAX_VOTERS];

// Number of candidates
int num_candidates;

// Number of voters
int num_voters;

// Function to initialize the voting system
void init_voting_system() {
    // Initialize the candidates
    num_candidates = 0;

    // Initialize the voters
    num_voters = 0;
}

// Function to add a candidate to the voting system
void add_candidate(char *name) {
    // Check if the number of candidates has reached the maximum
    if (num_candidates == MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }

    // Add the candidate to the array of candidates
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;

    // Increment the number of candidates
    num_candidates++;
}

// Function to add a voter to the voting system
void add_voter(char *name) {
    // Check if the number of voters has reached the maximum
    if (num_voters == MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }

    // Add the voter to the array of voters
    strcpy(voters[num_voters].name, name);
    voters[num_voters].voted = 0;

    // Increment the number of voters
    num_voters++;
}

// Function to cast a vote
void cast_vote(char *voter_name, char *candidate_name) {
    // Find the voter in the array of voters
    int voter_index = -1;
    for (int i = 0; i < num_voters; i++) {
        if (strcmp(voters[i].name, voter_name) == 0) {
            voter_index = i;
            break;
        }
    }

    // Check if the voter has already voted
    if (voter_index == -1 || voters[voter_index].voted == 1) {
        printf("Error: Voter has already voted or does not exist.\n");
        return;
    }

    // Find the candidate in the array of candidates
    int candidate_index = -1;
    for (int i = 0; i < num_candidates; i++) {
        if (strcmp(candidates[i].name, candidate_name) == 0) {
            candidate_index = i;
            break;
        }
    }

    // Check if the candidate exists
    if (candidate_index == -1) {
        printf("Error: Candidate does not exist.\n");
        return;
    }

    // Cast the vote
    candidates[candidate_index].votes++;
    voters[voter_index].voted = 1;
}

// Function to print the results of the election
void print_results() {
    // Find the winner
    int winner_index = -1;
    int max_votes = -1;
    for (int i = 0; i < num_candidates; i++) {
        if (candidates[i].votes > max_votes) {
            winner_index = i;
            max_votes = candidates[i].votes;
        }
    }

    // Print the winner
    printf("The winner of the election is: %s\n", candidates[winner_index].name);
}

// Main function
int main() {
    // Initialize the voting system
    init_voting_system();

    // Add some candidates to the voting system
    add_candidate("Alice");
    add_candidate("Bob");
    add_candidate("Charlie");

    // Add some voters to the voting system
    add_voter("John");
    add_voter("Mary");
    add_voter("Tom");

    // Cast some votes
    cast_vote("John", "Alice");
    cast_vote("Mary", "Bob");
    cast_vote("Tom", "Charlie");

    // Print the results of the election
    print_results();

    return 0;
}