//Falcon2-11B DATASET v1.0 Category: Networking ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>

int main() {
    int sockfd, portno, n;
    struct sockaddr_in serv_addr;
    struct hostent *server;

    // Creating socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Assigning port number
    portno = 8080;
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(portno);

    // Connecting to the server
    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    // Sending data
    char buf[1024] = "Hello, world!";
    n = write(sockfd, buf, strlen(buf));
    if (n < 0) {
        perror("write failed");
        exit(EXIT_FAILURE);
    }

    // Receiving data
    bzero(buf, sizeof(buf));
    n = read(sockfd, buf, sizeof(buf));
    if (n < 0) {
        perror("read failed");
        exit(EXIT_FAILURE);
    }
    printf("Received: %s\n", buf);

    // Closing the socket
    close(sockfd);

    return 0;
}