//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <string.h>

#define SNAP_LEN 1518

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet);
void analyze_ip(const struct ip *ip_header);
void analyze_tcp(const struct tcphdr *tcp_header);
void analyze_udp(const struct udphdr *udp_header);
void print_packet_info(const u_char *packet, struct pcap_pkthdr header);

int main(int argc, char *argv[]) {
    char *dev;
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;

    if (argc != 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return 1;
    }

    dev = argv[1];

    handle = pcap_open_live(dev, SNAP_LEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return 2;
    }

    pcap_loop(handle, 0, packet_handler, NULL);
  
    pcap_close(handle);
    return 0;
}

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    print_packet_info(packet, *header);
}

void print_packet_info(const u_char *packet, struct pcap_pkthdr header) {
    struct ip *ip_header = (struct ip *)(packet + 14); // 14 bytes for Ethernet header

    if (ip_header->ip_p == IPPROTO_TCP) {
        analyze_tcp((struct tcphdr *)(packet + 14 + (ip_header->ip_hl * 4)));
    } else if (ip_header->ip_p == IPPROTO_UDP) {
        analyze_udp((struct udphdr *)(packet + 14 + (ip_header->ip_hl * 4)));
    }

    analyze_ip(ip_header);
}

void analyze_ip(const struct ip *ip_header) {
    char src_ip[INET_ADDRSTRLEN], dest_ip[INET_ADDRSTRLEN];
    inet_ntop(AF_INET, &(ip_header->ip_src), src_ip, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &(ip_header->ip_dst), dest_ip, INET_ADDRSTRLEN);

    printf("IP Header:\n");
    printf("  Source: %s\n", src_ip);
    printf("  Destination: %s\n", dest_ip);
    printf("  Protocol: %d\n", ip_header->ip_p);
}

void analyze_tcp(const struct tcphdr *tcp_header) {
    printf("TCP Header:\n");
    printf("  Source Port: %d\n", ntohs(tcp_header->source));
    printf("  Destination Port: %d\n", ntohs(tcp_header->dest));
    printf("  Sequence Number: %u\n", ntohl(tcp_header->seq));
    printf("  Acknowledgment Number: %u\n", ntohl(tcp_header->ack_seq));
}

void analyze_udp(const struct udphdr *udp_header) {
    printf("UDP Header:\n");
    printf("  Source Port: %d\n", ntohs(udp_header->source));
    printf("  Destination Port: %d\n", ntohs(udp_header->dest));
    printf("  Length: %d\n", ntohs(udp_header->len));
}