//Gemma-7B DATASET v1.0 Category: Breakout Game Clone ; Style: random
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 5
#define BALL_SIZE 2

typedef struct Ball {
  int x, y;
  int dx, dy;
} Ball;

Ball balls[BOARD_SIZE * BOARD_SIZE];

void initialize_balls() {
  for (int i = 0; i < BOARD_SIZE * BOARD_SIZE; i++) {
    balls[i].x = rand() % BOARD_SIZE;
    balls[i].y = rand() % BOARD_SIZE;
    balls[i].dx = rand() % 2 - 1;
    balls[i].dy = rand() % 2 - 1;
  }
}

void update_balls() {
  for (int i = 0; i < BOARD_SIZE * BOARD_SIZE; i++) {
    balls[i].x += balls[i].dx;
    balls[i].y += balls[i].dy;

    if (balls[i].x >= BOARD_SIZE || balls[i].x < 0) {
      balls[i].dx *= -1;
    }

    if (balls[i].y >= BOARD_SIZE || balls[i].y < 0) {
      balls[i].dy *= -1;
    }
  }
}

void draw_balls() {
  for (int i = 0; i < BOARD_SIZE * BOARD_SIZE; i++) {
    printf("%c ", balls[i].x + balls[i].y * BOARD_SIZE);
  }
  printf("\n");
}

int main() {
  initialize_balls();
  update_balls();
  draw_balls();

  return 0;
}