//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define MAX_ACCOUNTS 1000
#define MAX_TRANSACTIONS 1000
#define MAX_NAME 50
#define MAX_AMOUNT_LENGTH 10

typedef struct {
    char name[MAX_NAME];
    int account_number;
    double balance;
} Account;

typedef struct {
    int from_account_number;
    int to_account_number;
    double amount;
    char description[MAX_NAME];
    time_t timestamp;
} Transaction;

int num_accounts = 0;
Account accounts[MAX_ACCOUNTS];

int num_transactions = 0;
Transaction transactions[MAX_TRANSACTIONS];

void add_account(char* name, int account_number, double initial_balance) {
    strcpy(accounts[num_accounts].name, name);
    accounts[num_accounts].account_number = account_number;
    accounts[num_accounts].balance = initial_balance;
    num_accounts++;
}

int find_account(int account_number) {
    for (int i = 0; i < num_accounts; i++) {
        if (accounts[i].account_number == account_number) {
            return i;
        }
    }
    return -1;
}

void add_transaction(int from_account_number, int to_account_number, double amount, char* description) {
    int index = num_transactions++;
    transactions[index].from_account_number = from_account_number;
    transactions[index].to_account_number = to_account_number;
    transactions[index].amount = amount;
    strcpy(transactions[index].description, description);
    time(&transactions[index].timestamp);
}

void print_accounts() {
    printf("Accounts:\n");
    for (int i = 0; i < num_accounts; i++) {
        printf("%d. %s (%d) - $%.2f\n", i+1, accounts[i].name, accounts[i].account_number, accounts[i].balance);
    }
}

void print_transactions() {
    printf("\nTransactions:\n");
    for (int i = 0; i < num_transactions; i++) {
        printf("%s transferred $%.2f from account %d to account %d on %s\n",
                transactions[i].description,
                transactions[i].amount,
                transactions[i].from_account_number,
                transactions[i].to_account_number,
                ctime(&transactions[i].timestamp));
    }
}

int main() {
    add_account("John Doe", 12345, 1000.00);
    add_account("Jane Doe", 67890, 500.00);

    add_transaction(12345, 67890, 200.00, "Transfer");

    print_accounts();
    print_transactions();

    return 0;
}