//Falcon-180B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 10
#define MAX_PROCESS_NAME 20
#define MAX_PROCESS_TIME 100
#define MAX_PROCESS_PRIORITY 10

typedef struct {
    char name[MAX_PROCESS_NAME];
    int time;
    int priority;
} Process;

void init(Process *processes) {
    int i;
    for (i = 0; i < MAX_PROCESSES; i++) {
        strcpy(processes[i].name, "Process ");
        sprintf(&processes[i].name[8], "%d", i + 1);
        processes[i].time = rand() % MAX_PROCESS_TIME;
        processes[i].priority = rand() % MAX_PROCESS_PRIORITY;
    }
}

int compare_processes(const void *a, const void *b) {
    const Process *p1 = a;
    const Process *p2 = b;
    if (p1->time < p2->time) {
        return -1;
    } else if (p1->time > p2->time) {
        return 1;
    } else {
        if (p1->priority < p2->priority) {
            return -1;
        } else if (p1->priority > p2->priority) {
            return 1;
        } else {
            return 0;
        }
    }
}

void print_processes(Process *processes) {
    int i;
    printf("Processes:\n");
    for (i = 0; i < MAX_PROCESSES; i++) {
        printf("%s - Time: %d - Priority: %d\n", processes[i].name, processes[i].time, processes[i].priority);
    }
}

void schedule(Process *processes) {
    qsort(processes, MAX_PROCESSES, sizeof(Process), compare_processes);
    int i;
    for (i = 0; i < MAX_PROCESSES; i++) {
        printf("Executing process %s\n", processes[i].name);
    }
}

int main() {
    Process processes[MAX_PROCESSES];
    init(processes);
    print_processes(processes);
    schedule(processes);
    return 0;
}