//Code Llama-13B DATASET v1.0 Category: Networking ; Style: intelligent
/*
 * A simple C networking example program that sends a message to a server
 * over the internet.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080

int main(int argc, char **argv) {
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket() failed");
        exit(1);
    }

    // Set the server address and port
    struct sockaddr_in server_addr;
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect() failed");
        exit(1);
    }

    // Send a message to the server
    char message[] = "Hello, world!";
    send(sock, message, strlen(message), 0);

    // Receive the response from the server
    char buffer[1024];
    int n = recv(sock, buffer, sizeof(buffer), 0);
    if (n < 0) {
        perror("recv() failed");
        exit(1);
    }

    // Print the response
    printf("Received response: %s\n", buffer);

    // Close the socket
    close(sock);

    return 0;
}