//Falcon-180B DATASET v1.0 Category: Periodic Table Quiz ; Style: synchronous
#include <stdio.h>

#define ELEMENTS 118

struct element {
    char name[3];
    char symbol;
    int atomic_number;
    double atomic_weight;
    int group;
    int period;
};

void print_element(struct element element) {
    printf("%-3s %-2c %5d %10.2f %5d %5d\n", element.name, element.symbol, element.atomic_number, element.atomic_weight, element.group, element.period);
}

int main() {
    struct element elements[ELEMENTS];
    int i;

    // Initialize elements
    for (i = 0; i < ELEMENTS; i++) {
        elements[i].name[0] = '\0';
        elements[i].symbol = '\0';
        elements[i].atomic_number = 0;
        elements[i].atomic_weight = 0.0;
        elements[i].group = 0;
        elements[i].period = 0;
    }

    // Fill in elements
    elements[0].name[0] = 'H';
    elements[0].symbol = 'H';
    elements[0].atomic_number = 1;
    elements[0].atomic_weight = 1.008;
    elements[0].group = 1;
    elements[0].period = 1;

    elements[1].name[0] = 'H';
    elements[1].symbol = 'H';
    elements[1].atomic_number = 1;
    elements[1].atomic_weight = 2.014;
    elements[1].group = 1;
    elements[1].period = 1;

    elements[2].name[0] = 'He';
    elements[2].symbol = 'He';
    elements[2].atomic_number = 2;
    elements[2].atomic_weight = 4.003;
    elements[2].group = 18;
    elements[2].period = 1;

    // Fill in remaining elements
    for (i = 3; i < ELEMENTS; i++) {
        sprintf(elements[i].name, "%s%d", "Xe", i - 2);
        elements[i].symbol = 'X';
        elements[i].atomic_number = i;
        elements[i].atomic_weight = (double)i * 131.293;
        elements[i].group = 18;
        elements[i].period = 6;
    }

    // Print table header
    printf("Element\tSymbol\tAtomic Number\tAtomic Weight\tGroup\tPeriod\n");
    printf("-------------------------------------------\n");

    // Print elements
    for (i = 0; i < ELEMENTS; i++) {
        print_element(elements[i]);
    }

    return 0;
}