//GEMINI-pro DATASET v1.0 Category: String manipulation ; Style: retro
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[]) {
    if (argc < 2) {
        printf("Usage: %s <string>\n", argv[0]);
        return 1;
    }

    char *string = argv[1];
    int length = strlen(string);

    printf("Original string: %s\n", string);

    // Reverse the string
    for (int i = 0; i < length / 2; i++) {
        char temp = string[i];
        string[i] = string[length - i - 1];
        string[length - i - 1] = temp;
    }

    printf("Reversed string: %s\n", string);

    // Convert the string to uppercase
    for (int i = 0; i < length; i++) {
        string[i] = toupper(string[i]);
    }

    printf("Uppercase string: %s\n", string);

    // Convert the string to lowercase
    for (int i = 0; i < length; i++) {
        string[i] = tolower(string[i]);
    }

    printf("Lowercase string: %s\n", string);

    // Remove all spaces from the string
    char *new_string = malloc(length - 1);
    int j = 0;
    for (int i = 0; i < length; i++) {
        if (string[i] != ' ') {
            new_string[j++] = string[i];
        }
    }
    new_string[j] = '\0';

    printf("String with spaces removed: %s\n", new_string);

    // Free the allocated memory
    free(new_string);

    return 0;
}