//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the number of stocks to track
#define NUM_STOCKS 5

// Define the stock market data structure
typedef struct Stock {
    char name[20];
    double price;
    double moving_average;
    double support_level;
    double resistance_level;
} Stock;

// Create an array of stocks
Stock stocks[NUM_STOCKS] = {
    {"Apple", 150.0, 140.0, 130.0, 160.0},
    {"Microsoft", 200.0, 190.0, 180.0, 210.0},
    {"Amazon", 120.0, 110.0, 100.0, 130.0},
    {"Tesla", 80.0, 70.0, 60.0, 90.0},
    {"Oracle", 100.0, 90.0, 80.0, 110.0}
};

// Calculate the moving average
double calculate_moving_average(Stock *stock, int days) {
    double sum = 0.0;
    for (int i = 0; i < days; i++) {
        sum += stock->price;
    }
    return sum / days;
}

// Calculate the support and resistance levels
double calculate_support_level(Stock *stock, double percentage) {
    return stock->moving_average - (stock->moving_average * percentage);
}

double calculate_resistance_level(Stock *stock, double percentage) {
    return stock->moving_average + (stock->moving_average * percentage);
}

// Print the stock market data
void print_stock_market_data() {
    for (int i = 0; i < NUM_STOCKS; i++) {
        printf("%s: $%.2f, MA: $%.2f, Support: $%.2f, Resistance: $%.2f\n", stocks[i].name, stocks[i].price, stocks[i].moving_average, stocks[i].support_level, stocks[i].resistance_level);
    }
}

int main() {
    // Calculate the moving average, support and resistance levels for each stock
    for (int i = 0; i < NUM_STOCKS; i++) {
        stocks[i].moving_average = calculate_moving_average(&stocks[i], 50);
        stocks[i].support_level = calculate_support_level(&stocks[i], 10.0);
        stocks[i].resistance_level = calculate_resistance_level(&stocks[i], 15.0);
    }

    // Print the stock market data
    print_stock_market_data();

    return 0;
}