//MISTRAL-7B DATASET v1.0 Category: Greedy Algorithms ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_VILLAGES 100
#define INF 999999

typedef struct {
    char name[20];
    int x, y;
    int romantic_feeling[MAX_VILLAGES];
} Village;

Village villages[MAX_VILLAGES];
int n, m, start, end;
int dist[MAX_VILLAGES][MAX_VILLAGES];
int visited[MAX_VILLAGES];

void init() {
    for (int i = 0; i < MAX_VILLAGES; i++) {
        dist[i][i] = 0;
        visited[i] = 0;
    }
}

void read_data() {
    scanf("%d %d %d", &n, &m, &start);
    for (int i = 0; i < n; i++) {
        scanf("%s %d %d", villages[i].name, &villages[i].x, &villages[i].y);
        for (int j = 0; j < m; j++) {
            int v1, v2, feeling;
            scanf("%d %d %d", &v1, &v2, &feeling);
            dist[v1][v2] = feeling;
            dist[v2][v1] = feeling;
        }
    }
}

int min_distance(int current_village) {
    int min = INF;
    int min_index;

    for (int i = 0; i < n; i++) {
        if (dist[current_village][i] != INF && visited[i] == 0) {
            if (dist[current_village][i] < min) {
                min = dist[current_village][i];
                min_index = i;
            }
        }
    }

    return min_index;
}

void print_path(int current_village) {
    if (current_village == end) {
        printf("%s\n", villages[current_village].name);
        return;
    }

    print_path(dist[current_village][min_distance(current_village)]);
    printf("%s <---> %s\n", villages[current_village].name, villages[min_distance(current_village)].name);
}

void dijkstra() {
    int current_village = start;

    visited[start] = 1;

    for (int i = 0; i < n - 1; i++) {
        int next_village = min_distance(current_village);

        current_village = next_village;
        visited[next_village] = 1;
    }
}

int main() {
    init();
    read_data();

    dijkstra();

    printf("The most romantic path from village %s to village %s is:\n", villages[start].name, villages[end].name);
    print_path(start);

    return 0;
}