//Code Llama-13B DATASET v1.0 Category: Basic Unix-like Shell ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>

#define MAX_ARGS 10
#define MAX_CMD_LEN 1024

int main(int argc, char **argv) {
    // Create a child process
    pid_t pid = fork();

    // If the child process is created successfully
    if (pid == 0) {
        // Close the unused file descriptor
        close(1);

        // Open a file in write mode
        int fd = open("output.txt", O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR);

        // Duplicate the file descriptor to stdout
        dup2(fd, 1);

        // Close the file descriptor
        close(fd);

        // Execute the command
        execvp(argv[1], &argv[1]);

        // If the command execution failed
        if (execvp(argv[1], &argv[1]) == -1) {
            perror("execvp");
            exit(EXIT_FAILURE);
        }
    } else {
        // Wait for the child process to terminate
        wait(NULL);

        // Read the contents of the output file
        int fd = open("output.txt", O_RDONLY);
        char buf[MAX_CMD_LEN];
        read(fd, buf, MAX_CMD_LEN);

        // Print the contents of the output file
        printf("Output: %s\n", buf);

        // Close the file descriptor
        close(fd);
    }

    return 0;
}