//GEMINI-pro DATASET v1.0 Category: Database simulation ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of records in the database
#define MAX_RECORDS 100

// Define the maximum length of a record
#define MAX_RECORD_LENGTH 100

// Define the structure of a record
typedef struct {
  char name[MAX_RECORD_LENGTH];
  int age;
  char address[MAX_RECORD_LENGTH];
} record;

// Define the database
record database[MAX_RECORDS];

// Define the current number of records in the database
int num_records = 0;

// Function to add a record to the database
void add_record(char *name, int age, char *address) {
  // Check if the database is full
  if (num_records >= MAX_RECORDS) {
    printf("Error: the database is full\n");
    return;
  }

  // Add the record to the database
  strcpy(database[num_records].name, name);
  database[num_records].age = age;
  strcpy(database[num_records].address, address);

  // Increment the number of records in the database
  num_records++;
}

// Function to search for a record in the database
int search_record(char *name) {
  // Iterate over the records in the database
  for (int i = 0; i < num_records; i++) {
    // Check if the record matches the given name
    if (strcmp(database[i].name, name) == 0) {
      // Return the index of the record
      return i;
    }
  }

  // Return -1 if the record was not found
  return -1;
}

// Function to delete a record from the database
void delete_record(char *name) {
  // Search for the record in the database
  int index = search_record(name);

  // Check if the record was found
  if (index == -1) {
    printf("Error: the record was not found\n");
    return;
  }

  // Delete the record from the database
  for (int i = index; i < num_records - 1; i++) {
    database[i] = database[i + 1];
  }

  // Decrement the number of records in the database
  num_records--;
}

// Function to print the database
void print_database() {
  // Iterate over the records in the database
  for (int i = 0; i < num_records; i++) {
    // Print the record
    printf("Name: %s\n", database[i].name);
    printf("Age: %d\n", database[i].age);
    printf("Address: %s\n\n", database[i].address);
  }
}

// Main function
int main() {
  // Add some records to the database
  add_record("John Doe", 30, "123 Main Street");
  add_record("Jane Doe", 25, "456 Elm Street");
  add_record("John Smith", 40, "789 Oak Street");

  // Search for a record in the database
  int index = search_record("Jane Doe");
  if (index != -1) {
    printf("Found record: %s\n", database[index].name);
  } else {
    printf("Record not found\n");
  }

  // Delete a record from the database
  delete_record("John Doe");

  // Print the database
  print_database();

  return 0;
}