//GPT-4o-mini DATASET v1.0 Category: Planet Gravity Simulation ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define GRAVITY_CONSTANT 9.81 // Gravity constant on Earth. Need a reference, right?
#define NUM_PLANETS 5          // Because more planets = more fun!

typedef struct {
    char name[20];
    double mass;  // In kilograms, or as we like to say, 'the universe's weighty problem'
    double radius; // In meters (don't ask about the circumference, that's a silly question)
    double distance; // Distance from the sun (or as we call it – 'that big burning ball of gas')
} Planet;

void initializePlanets(Planet planets[]) {
    // We'll just use some random masses and radii for our planets. Eat your heart out, NASA!
    snprintf(planets[0].name, sizeof(planets[0].name), "Pluto");
    planets[0].mass = 1.3e22; // Not a planet anymore, just sad!
    planets[0].radius = 1188; // Small and dense!

    snprintf(planets[1].name, sizeof(planets[1].name), "Mars");
    planets[1].mass = 6.39e23; // The Red Planet, not the angry one!
    planets[1].radius = 3389.5; // Shorter than a good vacation!

    snprintf(planets[2].name, sizeof(planets[2].name), "Earth");
    planets[2].mass = 5.97e24; // Where all the action is!
    planets[2].radius = 6371; // Round and full of life!

    snprintf(planets[3].name, sizeof(planets[3].name), "Jupiter");
    planets[3].mass = 1.89e27; // The big cheese!
    planets[3].radius = 69911; // Yikes, it's too big to hug!

    snprintf(planets[4].name, sizeof(planets[4].name), "Saturn");
    planets[4].mass = 5.68e26; // The ring master of the solar system!
    planets[4].radius = 58232; // Those rings could slice a pizza!
}

double calculateGravity(Planet planet) {
    // Forget black holes, this is the real reason we can't jump too high!
    return (GRAVITY_CONSTANT * planet.mass) / (planet.radius * planet.radius);
}

void printGravity(Planet planet, double gravity) {
    printf("On planet %s, the gravitational pull is %.2f m/s². Remember: what goes up must come down!\n",
           planet.name, gravity);
}

void simulateGravities() {
    Planet planets[NUM_PLANETS];
    initializePlanets(planets);
    
    printf("Welcome to the Planet Gravity Simulator 3000!\n");
    printf("Let's see how much these planets are pulling us down!\n\n");

    for (int i = 0; i < NUM_PLANETS; ++i) {
        double gravity = calculateGravity(planets[i]);
        printGravity(planets[i], gravity);
    }

    printf("\nNote: All calculations are approximate, much like your chances of winning the lottery!\n");
    printf("Thanks for playing. Remember, if you leave Earth, pack lightly - trust me!\n");
}

int main() {
    srand(time(NULL)); // Let's get a little random... not that we can blame it on luck!
    simulateGravities();
    return 0;
}