//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

// Define the maximum number of devices that can be connected to the smart home system
#define MAX_DEVICES 10

// Define the maximum length of a device name
#define MAX_DEVICE_NAME_LENGTH 32

// Define the types of devices that can be connected to the smart home system
typedef enum {
    DEVICE_TYPE_LIGHT,
    DEVICE_TYPE_SWITCH,
    DEVICE_TYPE_SENSOR
} device_type_t;

// Define the states that a device can be in
typedef enum {
    DEVICE_STATE_OFF,
    DEVICE_STATE_ON
} device_state_t;

// Define a structure to represent a device
typedef struct {
    char name[MAX_DEVICE_NAME_LENGTH];
    device_type_t type;
    device_state_t state;
} device_t;

// Define an array to store the devices that are connected to the smart home system
device_t devices[MAX_DEVICES];

// Define the number of devices that are currently connected to the smart home system
int num_devices = 0;

// Define a function to add a device to the smart home system
void add_device(char *name, device_type_t type) {
    // Check if the maximum number of devices has been reached
    if (num_devices >= MAX_DEVICES) {
        printf("Error: The maximum number of devices has been reached.\n");
        return;
    }

    // Check if the device name is valid
    if (strlen(name) > MAX_DEVICE_NAME_LENGTH) {
        printf("Error: The device name is too long.\n");
        return;
    }

    // Add the device to the array of devices
    strcpy(devices[num_devices].name, name);
    devices[num_devices].type = type;
    devices[num_devices].state = DEVICE_STATE_OFF;

    // Increment the number of devices
    num_devices++;

    // Print a message to indicate that the device has been added
    printf("Device \"%s\" added.\n", name);
}

// Define a function to remove a device from the smart home system
void remove_device(char *name) {
    // Find the index of the device in the array of devices
    int index = -1;
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            index = i;
            break;
        }
    }

    // Check if the device was found
    if (index == -1) {
        printf("Error: The device \"%s\" was not found.\n", name);
        return;
    }

    // Remove the device from the array of devices
    for (int i = index; i < num_devices - 1; i++) {
        devices[i] = devices[i + 1];
    }

    // Decrement the number of devices
    num_devices--;

    // Print a message to indicate that the device has been removed
    printf("Device \"%s\" removed.\n", name);
}

// Define a function to turn on a device
void turn_on_device(char *name) {
    // Find the index of the device in the array of devices
    int index = -1;
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            index = i;
            break;
        }
    }

    // Check if the device was found
    if (index == -1) {
        printf("Error: The device \"%s\" was not found.\n", name);
        return;
    }

    // Check if the device is already on
    if (devices[index].state == DEVICE_STATE_ON) {
        printf("Error: The device \"%s\" is already on.\n", name);
        return;
    }

    // Turn on the device
    devices[index].state = DEVICE_STATE_ON;

    // Print a message to indicate that the device has been turned on
    printf("Device \"%s\" turned on.\n", name);
}

// Define a function to turn off a device
void turn_off_device(char *name) {
    // Find the index of the device in the array of devices
    int index = -1;
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            index = i;
            break;
        }
    }

    // Check if the device was found
    if (index == -1) {
        printf("Error: The device \"%s\" was not found.\n", name);
        return;
    }

    // Check if the device is already off
    if (devices[index].state == DEVICE_STATE_OFF) {
        printf("Error: The device \"%s\" is already off.\n", name);
        return;
    }

    // Turn off the device
    devices[index].state = DEVICE_STATE_OFF;

    // Print a message to indicate that the device has been turned off
    printf("Device \"%s\" turned off.\n", name);
}

// Define a function to print the status of all devices
void print_devices() {
    // Print the header
    printf("Devices:\n");

    // Print the status of each device
    for (int i = 0; i < num_devices; i++) {
        printf("  %s: %s\n", devices[i].name, devices[i].state == DEVICE_STATE_ON ? "on" : "off");
    }
}

// Define the main function
int main() {
    // Add some devices to the smart home system
    add_device("Living Room Light", DEVICE_TYPE_LIGHT);
    add_device("Kitchen Switch", DEVICE_TYPE_SWITCH);
    add_device("Front Door Sensor", DEVICE_TYPE_SENSOR);

    // Print the status of all devices
    print_devices();

    // Turn on the living room light
    turn_on_device("Living Room Light");

    // Turn off the kitchen switch
    turn_off_device("Kitchen Switch");

    // Print the status of all devices
    print_devices();

    // Remove the front door sensor from the smart home system
    remove_device("Front Door Sensor");

    // Print the status of all devices
    print_devices();

    return 0;
}