//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the robot's initial position and orientation
double x = 0.0, y = 0.0, theta = 0.0;

// Define the robot's shape
double shape[4][2] = {
  { 0.0, 0.0 },
  { 1.0, 0.0 },
  { 1.0, 1.0 },
  { 0.0, 1.0 }
};

// Define the robot's movement commands
char commands[] = "F+F-F+F-F-";

// Define the robot's movement rules
void move_forward() {
  x += cos(theta);
  y += sin(theta);
}

void turn_left() {
  theta -= M_PI / 2;
}

void turn_right() {
  theta += M_PI / 2;
}

void change_shape() {
  for (int i = 0; i < 4; i++) {
    double new_x = shape[i][0] * cos(theta) - shape[i][1] * sin(theta);
    double new_y = shape[i][0] * sin(theta) + shape[i][1] * cos(theta);
    shape[i][0] = new_x;
    shape[i][1] = new_y;
  }
}

// Main program loop
int main() {
  // Loop through the movement commands
  for (int i = 0; i < strlen(commands); i++) {
    // Execute the movement command
    switch (commands[i]) {
      case 'F':
        move_forward();
        break;
      case '+':
        turn_left();
        break;
      case '-':
        turn_right();
        break;
      case '[':
        change_shape();
        break;
      case ']':
        change_shape();
        break;
    }
  }

  // Print the robot's final position and orientation
  printf("Final position: (%f, %f)\n", x, y);
  printf("Final orientation: %f\n", theta);

  return 0;
}