//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: creative
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    float price;
    int quantity;
} Item;

Item items[MAX_ITEMS];

void addItem(char name, float price, int quantity) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].price = price;
            items[i].quantity = quantity;
            return;
        }
    }

    printf("Error: Item limit reached.\n");
}

void showItems() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s - %.2f (Q: %d)\n", items[i].name, items[i].price, items[i].quantity);
        }
    }
}

void calculateBill() {
    float total = 0;
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            total += items[i].price * items[i].quantity;
        }
    }

    printf("Total: %.2f\n", total);
}

int main() {
    addItem("Coffee", 2.50, 2);
    addItem("Tea", 3.00, 1);
    addItem("Juice", 2.00, 3);

    showItems();

    calculateBill();

    return 0;
}