//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>

#define MAX_CAPTURES 1024
#define SNAP_LEN 1518

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet);
void print_packet(const u_char *packet, int len);

int main(int argc, char *argv[]) {
    char *dev = NULL;                       // Network device
    char errbuf[PCAP_ERRBUF_SIZE];         // Error buffer
    pcap_t *handle;                        // Packet capture handle

    // Find a network device to capture packets
    dev = pcap_lookupdev(errbuf);
    if (dev == NULL) {
        fprintf(stderr, "Unable to find device: %s\n", errbuf);
        return EXIT_FAILURE;
    }

    // Open the device for packet capturing
    handle = pcap_open_live(dev, SNAP_LEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Unable to open device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    printf("Listening on device %s...\n", dev);

    // Start the capture loop
    pcap_loop(handle, MAX_CAPTURES, packet_handler, NULL);

    // Cleanup
    pcap_close(handle);
    return EXIT_SUCCESS;
}

// Function to process captured packets
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Packet captured: Length = %d bytes\n", header->len);
    print_packet(packet, header->len);
}

// Function to print packet details
void print_packet(const u_char *packet, int len) {
    int i;
    const u_char *header;

    // Print an Ethernet header
    header = packet;
    printf("\nEthernet Header:\n");
    printf("Source: ");
    for (i = 6; i > 0; i--) {
        printf("%02x%c", header[i - 1], (i > 1) ? ':' : ' ');
    }
    printf("Destination: ");
    for (i = 0; i < 6; i++) {
        printf("%02x%c", header[i], (i < 5) ? ':' : '\n');
    }

    // Print rest of the packet in a readable format
    printf("Packet Data (hex): ");
    for (i = 0; i < len; i++) {
        printf("%02x ", packet[i]);
        if ((i + 1) % 16 == 0) {
            printf("\n");
        }
    }
    printf("\n");
}