//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: complete
#include <stdlib.h>
#include <time.h>

#define NUM_LANE 3
#define NUM_CARS 10

typedef struct Car
{
    int lane;
    int position;
    int speed;
    int direction;
} Car;

Car cars[NUM_CARS];

void simulateTrafficFlow()
{
    // Seed the random number generator
    srand(time(NULL));

    // Move the cars
    for (int i = 0; i < NUM_CARS; i++)
    {
        cars[i].position++;

        // Change lane if necessary
        if (cars[i].speed % 2 == 0)
        {
            cars[i].lane = (cars[i].lane + 1) % NUM_LANE;
        }

        // Adjust speed
        cars[i].speed++;

        // Change direction if necessary
        if (cars[i].position > 100)
        {
            cars[i].direction *= -1;
        }
    }

    // Print the car positions
    for (int i = 0; i < NUM_CARS; i++)
    {
        printf("Car %d is in lane %d, position %d\n", i, cars[i].lane, cars[i].position);
    }
}

int main()
{
    simulateTrafficFlow();

    return 0;
}