//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 5
#define MAX_VOTERS 1000
#define MAX_NAME_LENGTH 50

typedef struct {
    char name[MAX_NAME_LENGTH];
    int votes;
} candidate_t;

typedef struct {
    int voter_id;
    int candidate_id;
} vote_t;

candidate_t candidates[MAX_CANDIDATES];
vote_t votes[MAX_VOTERS];
int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_vote(int voter_id, int candidate_id) {
    if (num_voters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }
    votes[num_voters].voter_id = voter_id;
    votes[num_voters].candidate_id = candidate_id;
    num_voters++;
}

void print_candidates() {
    printf("Candidates:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%d. %s\n", i + 1, candidates[i].name);
    }
}

void print_votes() {
    printf("Votes:\n");
    for (int i = 0; i < num_voters; i++) {
        printf("Voter %d voted for candidate %d.\n", votes[i].voter_id, votes[i].candidate_id);
    }
}

void count_votes() {
    for (int i = 0; i < num_voters; i++) {
        candidates[votes[i].candidate_id - 1].votes++;
    }
}

int main() {
    add_candidate("Alice");
    add_candidate("Bob");
    add_candidate("Charlie");
    add_candidate("David");
    add_candidate("Eve");

    add_vote(1, 1);
    add_vote(2, 2);
    add_vote(3, 3);
    add_vote(4, 1);
    add_vote(5, 2);

    count_votes();

    print_candidates();
    print_votes();

    return 0;
}