//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CARS 10
#define MAX_LANE 3

typedef struct car {
  int lane;
  int position;
  int speed;
  int direction;
} car;

void simulateTrafficFlow(car cars[], int numCars) {
  for (int i = 0; i < numCars; i++) {
    switch (cars[i].direction) {
      case 1:
        cars[i].position++;
        if (cars[i].position >= MAX_LANE) {
          cars[i].direction = -1;
          cars[i].position = MAX_LANE - 1;
        }
        break;
      case -1:
        cars[i].position--;
        if (cars[i].position <= 0) {
          cars[i].direction = 1;
          cars[i].position = 0;
        }
        break;
    }
  }
}

int main() {
  car cars[MAX_CARS];
  int numCars = 5;

  for (int i = 0; i < numCars; i++) {
    cars[i].lane = rand() % MAX_LANE;
    cars[i].position = rand() % MAX_LANE;
    cars[i].speed = rand() % 5;
    cars[i].direction = rand() % 2;
  }

  simulateTrafficFlow(cars, numCars);

  for (int i = 0; i < numCars; i++) {
    printf("Car %d: lane %d, position %d, speed %d, direction %d\n", i + 1, cars[i].lane, cars[i].position, cars[i].speed, cars[i].direction);
  }

  return 0;
}