//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_EDGES 200

typedef struct {
    int id;
    char name[20];
} Node;

typedef struct {
    int source;
    int destination;
    int weight;
} Edge;

void addEdge(Edge edges[], int numEdges, int source, int destination, int weight) {
    if (numEdges >= MAX_EDGES) {
        printf("Error: Maximum number of edges reached.\n");
        return;
    }
    edges[numEdges].source = source;
    edges[numEdges].destination = destination;
    edges[numEdges].weight = weight;
    numEdges++;
}

void addNode(Node nodes[], int numNodes, int id, char name[]) {
    if (numNodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        return;
    }
    nodes[numNodes].id = id;
    strcpy(nodes[numNodes].name, name);
    numNodes++;
}

void printGraph(Edge edges[], int numEdges, Node nodes[], int numNodes) {
    printf("Graph:\n");
    for (int i = 0; i < numNodes; i++) {
        printf("Node %d: %s\n", nodes[i].id, nodes[i].name);
    }
    for (int i = 0; i < numEdges; i++) {
        printf("Edge %d: (%d, %d, %d)\n", i, edges[i].source, edges[i].destination, edges[i].weight);
    }
}

int main() {
    Node nodes[MAX_NODES];
    Edge edges[MAX_EDGES];
    int numNodes = 0;
    int numEdges = 0;

    // Add nodes
    addNode(nodes, numNodes, 1, "Node 1");
    addNode(nodes, numNodes, 2, "Node 2");
    addNode(nodes, numNodes, 3, "Node 3");
    addNode(nodes, numNodes, 4, "Node 4");
    addNode(nodes, numNodes, 5, "Node 5");

    // Add edges
    addEdge(edges, numEdges, 1, 2, 10);
    addEdge(edges, numEdges, 1, 3, 20);
    addEdge(edges, numEdges, 2, 4, 15);
    addEdge(edges, numEdges, 3, 4, 25);
    addEdge(edges, numEdges, 4, 5, 30);

    // Print graph
    printGraph(edges, numEdges, nodes, numNodes);

    return 0;
}