//GEMINI-pro DATASET v1.0 Category: Chess engine ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 8
#define WHITE 1
#define BLACK -1
#define EMPTY 0

typedef struct {
    int row;
    int col;
} Position;

typedef struct {
    int color;
    int type;
} Piece;

typedef struct {
    Piece board[BOARD_SIZE][BOARD_SIZE];
} Board;

void printBoard(Board* board) {
    for (int row = 0; row < BOARD_SIZE; row++) {
        for (int col = 0; col < BOARD_SIZE; col++) {
            Piece piece = board->board[row][col];
            printf("%c ", piece.color == WHITE ? 'w' : 'b');
        }
        printf("\n");
    }
}

int main() {
    Board board;

    // Initialize the board
    for (int row = 0; row < BOARD_SIZE; row++) {
        for (int col = 0; col < BOARD_SIZE; col++) {
            board.board[row][col].color = EMPTY;
            board.board[row][col].type = 0;
        }
    }

    // Place the pieces on the board
    board.board[0][0].color = BLACK;
    board.board[0][0].type = 1; // Rook
    board.board[0][1].color = BLACK;
    board.board[0][1].type = 2; // Knight
    board.board[0][2].color = BLACK;
    board.board[0][2].type = 3; // Bishop
    board.board[0][3].color = BLACK;
    board.board[0][3].type = 4; // Queen
    board.board[0][4].color = BLACK;
    board.board[0][4].type = 5; // King
    board.board[0][5].color = BLACK;
    board.board[0][5].type = 3; // Bishop
    board.board[0][6].color = BLACK;
    board.board[0][6].type = 2; // Knight
    board.board[0][7].color = BLACK;
    board.board[0][7].type = 1; // Rook

    board.board[7][0].color = WHITE;
    board.board[7][0].type = 1; // Rook
    board.board[7][1].color = WHITE;
    board.board[7][1].type = 2; // Knight
    board.board[7][2].color = WHITE;
    board.board[7][2].type = 3; // Bishop
    board.board[7][3].color = WHITE;
    board.board[7][3].type = 4; // Queen
    board.board[7][4].color = WHITE;
    board.board[7][4].type = 5; // King
    board.board[7][5].color = WHITE;
    board.board[7][5].type = 3; // Bishop
    board.board[7][6].color = WHITE;
    board.board[7][6].type = 2; // Knight
    board.board[7][7].color = WHITE;
    board.board[7][7].type = 1; // Rook

    // Print the board
    printBoard(&board);

    return 0;
}