//MISTRAL-7B DATASET v1.0 Category: Database simulation ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Structure for Student Records
typedef struct Student {
    char name[50];
    int roll_number;
    float cgpa;
} Student;

// Function to generate random student records
Student generate_student() {
    Student student;
    strcpy(student.name, "Student Unknown");
    student.roll_number = rand() % 100 + 1;
    student.cgpa = (float) rand() / RAND_MAX;
    return student;
}

// Function to print student record
void print_student(Student student) {
    printf("\nName: %s\nRoll Number: %d\nCGPA: %.2f", student.name, student.roll_number, student.cgpa);
}

// Function to create and initialize an array of student records
void initialize_students(Student students[], int size) {
    for (int i = 0; i < size; i++) {
        students[i] = generate_student();
    }
}

// Function to find the student with the highest CGPA
Student find_top_student(Student students[], int size) {
    Student top_student = students[0];
    for (int i = 1; i < size; i++) {
        if (students[i].cgpa > top_student.cgpa) {
            top_student = students[i];
        }
    }
    return top_student;
}

int main() {
    srand(time(NULL)); // Seed for random number generator

    int size = 10;
    Student students[size];

    printf("Initial Student Records:\n");
    initialize_students(students, size);

    for (int i = 0; i < size; i++) {
        print_student(students[i]);
    }

    printf("\nTop Student:\n");
    Student top_student = find_top_student(students, size);
    print_student(top_student);

    return 0;
}