//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSES 5
#define MAX_TIME 10

struct process {
    int id;
    int arrivalTime;
    int burstTime;
    int waitingTime;
    int turnAroundTime;
};

void calculateWaitingTime(struct process *processes) {
    for (int i = 0; i < MAX_PROCESSES; i++) {
        processes[i].waitingTime = processes[i].arrivalTime - processes[i].burstTime;
    }
}

void calculateTurnAroundTime(struct process *processes) {
    for (int i = 0; i < MAX_PROCESSES; i++) {
        processes[i].turnAroundTime = processes[i].waitingTime + processes[i].burstTime;
    }
}

int main() {
    struct process processes[MAX_PROCESSES];

    // Seed the random number generator
    srand(time(NULL));

    // Create processes
    for (int i = 0; i < MAX_PROCESSES; i++) {
        processes[i].id = i + 1;
        processes[i].arrivalTime = rand() % MAX_TIME;
        processes[i].burstTime = rand() % MAX_TIME;
    }

    // Calculate waiting time
    calculateWaitingTime(processes);

    // Calculate turn-around time
    calculateTurnAroundTime(processes);

    // Print results
    for (int i = 0; i < MAX_PROCESSES; i++) {
        printf("Process %d: Arrival Time %d, Burst Time %d, Waiting Time %d, Turn-around Time %d\n", processes[i].id, processes[i].arrivalTime, processes[i].burstTime, processes[i].waitingTime, processes[i].turnAroundTime);
    }

    return 0;
}