//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include <stdbool.h>

#define NUM_LIGHTS 5
#define MAX_LIGHT_LEVEL 100
#define MIN_LIGHT_LEVEL 0
#define LIGHT_INCREMENT 5

int light_levels[NUM_LIGHTS] = {0, 0, 0, 0, 0};

void set_light_level(int light_index, int level) {
    if (light_index >= 0 && light_index < NUM_LIGHTS) {
        light_levels[light_index] = level;
    }
}

void turn_on_light(int light_index) {
    if (light_index >= 0 && light_index < NUM_LIGHTS) {
        light_levels[light_index] = MAX_LIGHT_LEVEL;
    }
}

void turn_off_light(int light_index) {
    if (light_index >= 0 && light_index < NUM_LIGHTS) {
        light_levels[light_index] = MIN_LIGHT_LEVEL;
    }
}

void toggle_light(int light_index) {
    if (light_index >= 0 && light_index < NUM_LIGHTS) {
        if (light_levels[light_index] == MAX_LIGHT_LEVEL) {
            light_levels[light_index] = MIN_LIGHT_LEVEL;
        } else {
            light_levels[light_index] = MAX_LIGHT_LEVEL;
        }
    }
}

void set_all_lights(int level) {
    for (int i = 0; i < NUM_LIGHTS; i++) {
        set_light_level(i, level);
    }
}

void print_light_levels() {
    for (int i = 0; i < NUM_LIGHTS; i++) {
        printf("Light %d: %d\n", i + 1, light_levels[i]);
    }
}

int main() {
    set_all_lights(50);
    print_light_levels();

    turn_on_light(1);
    turn_off_light(3);
    toggle_light(4);
    print_light_levels();

    set_all_lights(75);
    print_light_levels();

    return 0;
}