//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_COMPANIES 50
#define MAX_SYMBOLS 10
#define MAX_HISTORY 100

typedef struct {
    char symbol[MAX_SYMBOLS];
    char name[MAX_SYMBOLS];
    float price;
    int history[MAX_HISTORY];
    int history_index;
} company_t;

void add_company(company_t *companies, int num_companies, char *symbol, char *name, float price) {
    int i;
    for (i = 0; i < num_companies; i++) {
        if (strcmp(companies[i].symbol, symbol) == 0) {
            printf("Error: company already exists.\n");
            return;
        }
    }
    strcpy(companies[num_companies].symbol, symbol);
    strcpy(companies[num_companies].name, name);
    companies[num_companies].price = price;
    companies[num_companies].history_index = 0;
    memset(companies[num_companies].history, 0, sizeof(companies[num_companies].history));
    num_companies++;
}

void update_price(company_t *companies, int num_companies, char *symbol, float price) {
    int i;
    for (i = 0; i < num_companies; i++) {
        if (strcmp(companies[i].symbol, symbol) == 0) {
            companies[i].price = price;
            return;
        }
    }
    printf("Error: company not found.\n");
}

void print_companies(company_t *companies, int num_companies) {
    int i;
    for (i = 0; i < num_companies; i++) {
        printf("%s (%s): $%.2f\n", companies[i].symbol, companies[i].name, companies[i].price);
    }
}

void print_history(company_t *companies, int num_companies, char *symbol) {
    int i;
    for (i = 0; i < num_companies; i++) {
        if (strcmp(companies[i].symbol, symbol) == 0) {
            printf("History for %s:\n", companies[i].name);
            int j;
            for (j = companies[i].history_index - 1; j >= 0 && j < MAX_HISTORY - 1; j--) {
                printf("%d: $%.2f\n", j + 1, companies[i].history[j]);
            }
            printf("\n");
            return;
        }
    }
    printf("Error: company not found.\n");
}

void main() {
    company_t companies[MAX_COMPANIES];
    int num_companies = 0;

    add_company(companies, num_companies, "AAPL", "Apple Inc.", 150.00);
    add_company(companies, num_companies, "MSFT", "Microsoft Corporation", 100.00);
    add_company(companies, num_companies, "GOOG", "Alphabet Inc.", 1100.00);

    print_companies(companies, num_companies);

    update_price(companies, num_companies, "AAPL", 160.00);

    print_companies(companies, num_companies);

    print_history(companies, num_companies, "AAPL");
}