//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct {
    char name[50];
    int quantity;
    float price;
} item_t;

item_t items[MAX_ITEMS];
int num_items = 0;

void add_item(char *name, int quantity, float price) {
    if (num_items >= MAX_ITEMS) {
        printf("Warehouse is full! Can't add more items.\n");
        return;
    }

    strcpy(items[num_items].name, name);
    items[num_items].quantity = quantity;
    items[num_items].price = price;

    num_items++;
}

void print_items() {
    printf("Items in the warehouse:\n");
    for (int i = 0; i < num_items; i++) {
        printf("%s\t%d\t%.2f\n", items[i].name, items[i].quantity, items[i].price);
    }
}

void search_item(char *name) {
    int found = 0;

    for (int i = 0; i < num_items; i++) {
        if (strcmp(items[i].name, name) == 0) {
            printf("Item found:\n");
            printf("%s\t%d\t%.2f\n", items[i].name, items[i].quantity, items[i].price);
            found = 1;
            break;
        }
    }

    if (!found) {
        printf("Item not found.\n");
    }
}

void update_item(char *name, int new_quantity, float new_price) {
    int found = 0;

    for (int i = 0; i < num_items; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity = new_quantity;
            items[i].price = new_price;
            found = 1;
            break;
        }
    }

    if (!found) {
        printf("Item not found.\n");
    }
}

void delete_item(char *name) {
    int found = 0;

    for (int i = 0; i < num_items; i++) {
        if (strcmp(items[i].name, name) == 0) {
            for (int j = i + 1; j < num_items; j++) {
                items[j - 1] = items[j];
            }

            num_items--;
            found = 1;
            break;
        }
    }

    if (!found) {
        printf("Item not found.\n");
    }
}

int main() {
    add_item("Apple", 10, 1.5);
    add_item("Banana", 20, 2.0);
    add_item("Orange", 30, 2.5);
    add_item("Grapes", 40, 3.0);
    add_item("Strawberry", 50, 3.5);

    print_items();

    search_item("Orange");

    update_item("Banana", 30, 2.2);

    delete_item("Strawberry");

    print_items();

    return 0;
}