//Falcon-180B DATASET v1.0 Category: Database simulation ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LENGTH 50
#define MAX_NUM_ITEMS 100

typedef struct {
    char name[MAX_NAME_LENGTH];
    float price;
    int quantity;
} Item;

typedef struct {
    char name[MAX_NAME_LENGTH];
    int num_items;
    Item items[MAX_NUM_ITEMS];
} Store;

void add_item(Store* store, char* name, float price, int quantity) {
    if (store->num_items >= MAX_NUM_ITEMS) {
        printf("Error: cannot add more items to store.\n");
        return;
    }

    strcpy(store->items[store->num_items].name, name);
    store->items[store->num_items].price = price;
    store->items[store->num_items].quantity = quantity;

    store->num_items++;
}

void display_items(Store* store) {
    printf("Items in store:\n");
    for (int i = 0; i < store->num_items; i++) {
        printf("%s - $%.2f - %d\n", store->items[i].name, store->items[i].price, store->items[i].quantity);
    }
}

int main() {
    Store my_store = {"My Store", 0};

    add_item(&my_store, "Apples", 0.99, 100);
    add_item(&my_store, "Oranges", 1.29, 50);
    add_item(&my_store, "Bananas", 0.59, 200);

    display_items(&my_store);

    return 0;
}