//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Callback function to receive response data
size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp)
{
    ((char *)userp)[nmemb * size] = '\0'; // Null terminate the buffer
    return size * nmemb;
}

// Function to perform HTTP GET request
int PerformGETRequest(const char *url, char **response)
{
    CURL *curl;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if (curl) {
        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, response);

        res = curl_easy_perform(curl);
        if (res!= CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(res));
        }

        curl_easy_cleanup(curl);
    }

    curl_global_cleanup();
    return res;
}

int main()
{
    char *response = NULL;
    int res = PerformGETRequest("http://example.com", &response);

    if (res == CURLE_OK) {
        printf("Response:\n%s\n", response);
    } else {
        printf("Error: %s\n", curl_easy_strerror(res));
    }

    free(response);
    return 0;
}