//GEMINI-pro DATASET v1.0 Category: Network Packet Monitoring ; Style: retro
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <errno.h>
#include <time.h>
#include <signal.h>

#define PROMISCUOUS 1

// Packet capture callback function
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
  static int count = 1;
  struct tm *local_time;

  // Convert the timestamp to local time
  local_time = localtime(&header->ts.tv_sec);

  // Print packet information
  printf("%d: %s %s\n", count++, asctime(local_time), packet);
}

int main(int argc, char **argv) {
  if (argc < 2) {
    printf("Usage: %s <interface>\n", argv[0]);
    return EXIT_FAILURE;
  }

  char *interface = argv[1];

  // Open the network device for packet capture
  pcap_t *handle = pcap_open_live(interface, 65535, PROMISCUOUS, 1000, NULL);
  if (handle == NULL) {
    fprintf(stderr, "Error opening the network device: %s\n", pcap_geterr(handle));
    return EXIT_FAILURE;
  }

  // Set the filter expression
  struct bpf_program filter;
  if (pcap_compile(handle, &filter, "tcp", 1, 0) != 0) {
    fprintf(stderr, "Error compiling the filter expression: %s\n", pcap_geterr(handle));
    return EXIT_FAILURE;
  }
  if (pcap_setfilter(handle, &filter) != 0) {
    fprintf(stderr, "Error setting the filter: %s\n", pcap_geterr(handle));
    return EXIT_FAILURE;
  }

  // Start the packet capture loop
  pcap_loop(handle, -1, packet_handler, NULL);

  // Close the network device
  pcap_close(handle);

  return EXIT_SUCCESS;
}