//Falcon2-11B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: recursive
#include <stdio.h>
#include <math.h>

#define MAX_LENGTH 100

void divide(char operand[], int operand_length, char result[], int result_length) {
    if (operand_length == 0) {
        result[0] = '0';
        result[1] = '\0';
        return;
    }

    if (operand[operand_length - 1] == '/') {
        int quotient_length = operand_length - 2;
        char quotient[MAX_LENGTH];
        divide(operand, quotient_length, quotient, MAX_LENGTH);
        char remainder[MAX_LENGTH];
        divide(quotient, MAX_LENGTH, remainder, MAX_LENGTH);
        result[0] = '0';
        result[1] = '.';
        result[2] = '0';
        result[3] = '\0';
        int length = strlen(remainder);
        for (int i = 0; i < length; i++) {
            result[3 + i] = remainder[i];
        }
        result[3 + length] = '\0';
    } else {
        result[0] = operand[operand_length - 1];
        result[1] = '\0';
    }
}

void multiply(char operand[], int operand_length, char result[], int result_length) {
    if (operand_length == 0) {
        result[0] = '0';
        result[1] = '\0';
        return;
    }

    if (operand[operand_length - 1] == '*') {
        int product_length = operand_length - 2;
        char product[MAX_LENGTH];
        multiply(operand, product_length, product, MAX_LENGTH);
        result[0] = '0';
        result[1] = '.';
        result[2] = '0';
        result[3] = '\0';
        int length = strlen(product);
        for (int i = 0; i < length; i++) {
            result[3 + i] = product[i];
        }
        result[3 + length] = '\0';
    } else {
        result[0] = '0';
        result[1] = '.';
        result[2] = '0';
        result[3] = '\0';
        int length = strlen(operand);
        for (int i = 0; i < length; i++) {
            result[3 + i] = operand[i];
        }
        result[3 + length] = '\0';
    }
}

void add(char operand[], int operand_length, char result[], int result_length) {
    if (operand_length == 0) {
        result[0] = '0';
        result[1] = '\0';
        return;
    }

    if (operand[operand_length - 1] == '+') {
        int sum_length = operand_length - 2;
        char sum[MAX_LENGTH];
        add(operand, sum_length, sum, MAX_LENGTH);
        result[0] = '0';
        result[1] = '.';
        result[2] = '0';
        result[3] = '\0';
        int length = strlen(sum);
        for (int i = 0; i < length; i++) {
            result[3 + i] = sum[i];
        }
        result[3 + length] = '\0';
    } else {
        result[0] = '0';
        result[1] = '.';
        result[2] = '0';
        result[3] = '\0';
        int length = strlen(operand);
        for (int i = 0; i < length; i++) {
            result[3 + i] = operand[i];
        }
        result[3 + length] = '\0';
    }
}

void subtract(char operand[], int operand_length, char result[], int result_length) {
    if (operand_length == 0) {
        result[0] = '0';
        result[1] = '\0';
        return;
    }

    if (operand[operand_length - 1] == '-') {
        int difference_length = operand_length - 2;
        char difference[MAX_LENGTH];
        subtract(operand, difference_length, difference, MAX_LENGTH);
        result[0] = '0';
        result[1] = '.';
        result[2] = '0';
        result[3] = '\0';
        int length = strlen(difference);
        for (int i = 0; i < length; i++) {
            result[3 + i] = difference[i];
        }
        result[3 + length] = '\0';
    } else {
        result[0] = '0';
        result[1] = '.';
        result[2] = '0';
        result[3] = '\0';
        int length = strlen(operand);
        for (int i = 0; i < length; i++) {
            result[3 + i] = operand[i];
        }
        result[3 + length] = '\0';
    }
}

int main() {
    char operand[MAX_LENGTH];
    int operand_length = 0;

    printf("Enter an expression (e.g., 2 * 3 + 4 - 5): ");
    fgets(operand, MAX_LENGTH, stdin);

    int result_length = 0;
    char result[MAX_LENGTH];
    char operator[MAX_LENGTH];
    int operator_length = 0;

    divide(operand, operand_length, operator, operator_length);
    multiply(operator, operator_length, result, result_length);
    add(result, result_length, result, result_length);
    subtract(result, result_length, result, result_length);

    printf("Result: %s\n", result);

    return 0;
}