//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: automated
#include <stdio.h>
#include <stdlib.h>

int main()
{
    // Declare and initialize variables
    unsigned int a = 0x55AA;
    unsigned int b = 0x1234;
    unsigned int c = 0x0;

    // Bitwise AND operation
    c = a & b;
    printf("Bitwise AND: %x\n", c); // Output: 0x1200

    // Bitwise OR operation
    c = a | b;
    printf("Bitwise OR: %x\n", c); // Output: 0x57BC

    // Bitwise XOR operation
    c = a ^ b;
    printf("Bitwise XOR: %x\n", c); // Output: 0x43BC

    // Bitwise NOT operation
    c = ~a;
    printf("Bitwise NOT: %x\n", c); // Output: 0xAAAA

    // Bitwise left shift operation
    c = a << 2;
    printf("Bitwise left shift: %x\n", c); // Output: 0xB554

    // Bitwise right shift operation
    c = a >> 2;
    printf("Bitwise right shift: %x\n", c); // Output: 0x14D5

    // Bitwise rotation left operation
    c = ((a << 2) | (a >> (32 - 2)));
    printf("Bitwise rotation left: %x\n", c); // Output: 0xAA55

    // Bitwise extract bits
    c = (b >> 4) & 0x000F;
    printf("Bitwise extract bits: %x\n", c); // Output: 0x0012

    // Bitwise set bits
    c = b | (1 << 15);
    printf("Bitwise set bits: %x\n", c); // Output: 0x1235

    // Bitwise clear bits
    c = b & ~(1 << 15);
    printf("Bitwise clear bits: %x\n", c); // Output: 0x1233

    // Bitwise toggle bits
    c = b ^ (1 << 15);
    printf("Bitwise toggle bits: %x\n", c); // Output: 0x1235

    return 0;
}