//Falcon-180B DATASET v1.0 Category: Dice Roller ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_DICE 5
#define NUM_SIDES 6

int rollDice() {
    return rand() % NUM_SIDES + 1;
}

int rollDiceArray(int *diceArray, int numDice) {
    for (int i = 0; i < numDice; i++) {
        diceArray[i] = rollDice();
    }
}

void printDiceArray(int *diceArray, int numDice) {
    for (int i = 0; i < numDice; i++) {
        printf("%d ", diceArray[i]);
    }
    printf("\n");
}

int main() {
    srand(time(NULL));
    int diceArray[NUM_DICE];
    int total = 0;
    int sum = 0;
    int highest = 0;
    int lowest = 0;
    int frequency[NUM_SIDES] = {0};

    printf("Rolling %d %d-sided dice...\n", NUM_DICE, NUM_SIDES);
    rollDiceArray(diceArray, NUM_DICE);
    printDiceArray(diceArray, NUM_DICE);

    for (int i = 0; i < NUM_DICE; i++) {
        total += diceArray[i];
        sum += diceArray[i];
        if (diceArray[i] > highest) {
            highest = diceArray[i];
        }
        if (diceArray[i] < lowest) {
            lowest = diceArray[i];
        }
        frequency[diceArray[i] - 1]++;
    }

    printf("\nTotal: %d\n", total);
    printf("Sum: %d\n", sum);
    printf("Highest: %d\n", highest);
    printf("Lowest: %d\n", lowest);

    for (int i = 1; i < NUM_SIDES; i++) {
        printf("%d: %d\n", i, frequency[i]);
    }

    return 0;
}