//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#define NUM_THREADS 3
#define MAX_DELAY 5

int light_status = 0;
int light_delay = 0;

void* turn_on_light(void* arg) {
    int i;

    for (i = 0; i < MAX_DELAY; i++) {
        printf("Light turning on...\n");
        light_status = 1;
        sleep(1);
    }

    printf("Light is on.\n");

    pthread_exit(0);
}

void* turn_off_light(void* arg) {
    int i;

    for (i = 0; i < MAX_DELAY; i++) {
        printf("Light turning off...\n");
        light_status = 0;
        sleep(1);
    }

    printf("Light is off.\n");

    pthread_exit(0);
}

void* toggle_light(void* arg) {
    int i;

    for (i = 0; i < MAX_DELAY; i++) {
        if (light_status == 0) {
            printf("Light turning on...\n");
            light_status = 1;
        } else {
            printf("Light turning off...\n");
            light_status = 0;
        }

        sleep(1);
    }

    printf("Light toggled.\n");

    pthread_exit(0);
}

int main() {
    pthread_t threads[NUM_THREADS];

    int i;
    for (i = 0; i < NUM_THREADS; i++) {
        switch (i) {
            case 0:
                pthread_create(&threads[i], NULL, turn_on_light, NULL);
                break;
            case 1:
                pthread_create(&threads[i], NULL, turn_off_light, NULL);
                break;
            case 2:
                pthread_create(&threads[i], NULL, toggle_light, NULL);
                break;
            default:
                break;
        }
    }

    for (i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}