//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LENGTH 100
#define MAX_EMAILS_PER_USER 10

typedef struct {
    char name[MAX_NAME_LENGTH];
    int num_emails;
    char emails[MAX_EMAILS_PER_USER][MAX_NAME_LENGTH];
} User;

void add_user(User *users, int num_users, char *name, char *email) {
    int i;
    for (i = 0; i < num_users; i++) {
        if (strcmp(users[i].name, name) == 0) {
            strcpy(users[i].emails[users[i].num_emails], email);
            users[i].num_emails++;
            return;
        }
    }
    strcpy(users[num_users].name, name);
    strcpy(users[num_users].emails[0], email);
    users[num_users].num_emails = 1;
    num_users++;
}

void remove_user(User *users, int *num_users, char *name) {
    int i;
    for (i = 0; i < *num_users; i++) {
        if (strcmp(users[i].name, name) == 0) {
            memmove(&users[i], &users[i+1], (*num_users - i - 1) * sizeof(User));
            (*num_users)--;
            return;
        }
    }
}

void print_users(User *users, int num_users) {
    int i, j;
    for (i = 0; i < num_users; i++) {
        printf("Name: %s\n", users[i].name);
        printf("Emails:\n");
        for (j = 0; j < users[i].num_emails; j++) {
            printf("  %s\n", users[i].emails[j]);
        }
        printf("\n");
    }
}

int main() {
    User users[100];
    int num_users = 0;

    add_user(users, num_users, "John Doe", "johndoe@example.com");
    add_user(users, num_users, "Jane Doe", "janedoe@example.com");

    print_users(users, num_users);

    remove_user(users, &num_users, "Jane Doe");

    print_users(users, num_users);

    return 0;
}