//GEMINI-pro DATASET v1.0 Category: Basic Image Processing: Simple tasks like flipping an image, changing brightness/contrast ; Style: shocked
#include <stdio.h>
#include <stdlib.h>

void flip_image(unsigned char *image, int width, int height) {
  for (int y = 0; y < height; y++) {
    for (int x = 0; x < width / 2; x++) {
      unsigned char temp = image[y * width + x];
      image[y * width + x] = image[y * width + width - x - 1];
      image[y * width + width - x - 1] = temp;
    }
  }
}

void change_brightness_contrast(unsigned char *image, int width, int height, int brightness, int contrast) {
  for (int y = 0; y < height; y++) {
    for (int x = 0; x < width; x++) {
      int new_value = (image[y * width + x] + brightness) * contrast / 100;
      if (new_value < 0) new_value = 0;
      if (new_value > 255) new_value = 255;
      image[y * width + x] = new_value;
    }
  }
}

int main() {
  unsigned char image[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
  };

  int width = 8;
  int height = 8;

  printf("Original image:\n");
  for (int y = 0; y < height; y++) {
    for (int x = 0; x < width; x++) {
      printf("%3d ", image[y * width + x]);
    }
    printf("\n");
  }

  printf("\nFlipped image:\n");
  flip_image(image, width, height);
  for (int y = 0; y < height; y++) {
    for (int x = 0; x < width; x++) {
      printf("%3d ", image[y * width + x]);
    }
    printf("\n");
  }

  printf("\nBrightened image:\n");
  change_brightness_contrast(image, width, height, 50, 100);
  for (int y = 0; y < height; y++) {
    for (int x = 0; x < width; x++) {
      printf("%3d ", image[y * width + x]);
    }
    printf("\n");
  }

  printf("\nDarkened image:\n");
  change_brightness_contrast(image, width, height, -50, 100);
  for (int y = 0; y < height; y++) {
    for (int x = 0; x < width; x++) {
      printf("%3d ", image[y * width + x]);
    }
    printf("\n");
  }

  printf("\nContrasted image:\n");
  change_brightness_contrast(image, width, height, 0, 150);
  for (int y = 0; y < height; y++) {
    for (int x = 0; x < width; x++) {
      printf("%3d ", image[y * width + x]);
    }
    printf("\n");
  }

  return 0;
}