//Gemma-7B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BUFFER_SIZE 1024

typedef struct Calculator {
    char buffer[MAX_BUFFER_SIZE];
    int top;
    int history[100];
    int historyIndex;
} Calculator;

Calculator calculator;

void calculator_init() {
    calculator.top = -1;
    calculator.historyIndex = 0;
}

void calculator_push(char number) {
    if (calculator.top == MAX_BUFFER_SIZE - 1) {
        return;
    }
    calculator.buffer[++calculator.top] = number;
}

void calculator_pop() {
    if (calculator.top == -1) {
        return;
    }
    calculator.top--;
}

void calculator_clear() {
    calculator.top = -1;
    calculator.historyIndex = 0;
}

void calculator_history(int index) {
    if (calculator.historyIndex - index < 0) {
        return;
    }
    printf("%c", calculator.history[index]);
}

int main() {
    calculator_init();

    // Perform calculator operations
    calculator_push(5);
    calculator_push(6);
    calculator_push(2);
    calculator_push(3);
    calculator_push('+');
    calculator_push(8);
    calculator_push('=');

    // Display the result
    printf("%s", calculator.buffer);

    // Display the history
    calculator_history(0);

    return 0;
}