//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Sky conditions
typedef enum {
    SUNNY,
    CLOUDY,
    RAINING,
    SNOWING
} sky_condition_t;

// Weather data
typedef struct {
    sky_condition_t condition;
    int temperature;
    int humidity;
    int wind_speed;
} weather_data_t;

// Initialize weather data with random values
void init_weather_data(weather_data_t *weather) {
    srand(time(NULL));
    
    weather->condition = rand() % 4;
    weather->temperature = (rand() % 20) + 10;
    weather->humidity = (rand() % 50) + 50;
    weather->wind_speed = (rand() % 10) + 5;
}

// Print weather data
void print_weather_data(weather_data_t *weather) {
    printf("Sky condition: ");
    switch (weather->condition) {
        case SUNNY:
            printf("sunny");
            break;
        case CLOUDY:
            printf("cloudy");
            break;
        case RAINING:
            printf("raining");
            break;
        case SNOWING:
            printf("snowing");
            break;
    }
    printf("\n");
    printf("Temperature: %d degrees Celsius\n", weather->temperature);
    printf("Humidity: %d%%\n", weather->humidity);
    printf("Wind speed: %d km/h\n", weather->wind_speed);
}

// Main function
int main() {
    // Initialize weather data
    weather_data_t weather;
    init_weather_data(&weather);
    
    // Print weather data
    print_weather_data(&weather);
    
    return 0;
}