//GEMINI-pro DATASET v1.0 Category: Automated Fortune Teller ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>

// Structure to store a fortune
typedef struct {
    char *fortune;
    size_t length;
} fortune_t;

// Array of fortunes
fortune_t fortunes[] = {
    { .fortune = "You will have a long and happy life.", .length = 34 },
    { .fortune = "You will be rich and famous.", .length = 27 },
    { .fortune = "You will find true love.", .length = 24 },
    { .fortune = "You will make a difference in the world.", .length = 37 },
    { .fortune = "You will achieve your dreams.", .length = 28 },
    { .fortune = "You will be successful in everything you do.", .length = 40 },
    { .fortune = "You will be happy and content.", .length = 29 },
    { .fortune = "You will have a bright future.", .length = 28 },
    { .fortune = "You will be surrounded by loved ones.", .length = 35 },
    { .fortune = "You will be healthy and strong.", .length = 29 },
};

// Mutex to protect access to the fortunes array
pthread_mutex_t fortunes_mutex = PTHREAD_MUTEX_INITIALIZER;

// Function to generate a random fortune
fortune_t *generate_fortune() {
    // Lock the mutex to protect access to the fortunes array
    pthread_mutex_lock(&fortunes_mutex);

    // Generate a random index into the fortunes array
    int index = rand() % (sizeof(fortunes) / sizeof(fortune_t));

    // Get the fortune at the random index
    fortune_t *fortune = &fortunes[index];

    // Unlock the mutex to release the lock on the fortunes array
    pthread_mutex_unlock(&fortunes_mutex);

    return fortune;
}

// Function to print a fortune
void print_fortune(fortune_t *fortune) {
    // Print the fortune
    printf("%s\n", fortune->fortune);
}

// Function to handle the asynchronous request for a fortune
void *handle_fortune_request(void *arg) {
    // Generate a random fortune
    fortune_t *fortune = generate_fortune();

    // Print the fortune
    print_fortune(fortune);

    return NULL;
}

int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Create a thread to handle the asynchronous request for a fortune
    pthread_t thread;
    pthread_create(&thread, NULL, handle_fortune_request, NULL);

    // Join the thread to wait for it to finish
    pthread_join(thread, NULL);

    return 0;
}