//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: Ada Lovelace
// Ada Lovelace's CPU Scheduling Algorithms Example

// Constants
#define NUM_PROCESSES 5
#define MAX_PRIORITY 10

// Process structure
typedef struct {
  int arrivalTime;
  int burstTime;
  int priority;
} Process;

// Function to sort processes by arrival time
int compareArrivalTime(const void *a, const void *b) {
  Process *p1 = (Process *)a;
  Process *p2 = (Process *)b;
  return p1->arrivalTime - p2->arrivalTime;
}

// Function to sort processes by priority
int comparePriority(const void *a, const void *b) {
  Process *p1 = (Process *)a;
  Process *p2 = (Process *)b;
  return p2->priority - p1->priority;
}

// Function to execute the First-Come, First-Served (FCFS) algorithm
void fcfs(Process processes[]) {
  // Sort processes by arrival time
  qsort(processes, NUM_PROCESSES, sizeof(Process), compareArrivalTime);

  // Execute processes
  int currentTime = 0;
  for (int i = 0; i < NUM_PROCESSES; i++) {
    Process *process = &processes[i];
    printf("Process %d: ", i + 1);
    currentTime += process->burstTime;
    printf("Arrival time: %d\n", process->arrivalTime);
    printf("Burst time: %d\n", process->burstTime);
    printf("Start time: %d\n", currentTime - process->burstTime);
    printf("End time: %d\n\n", currentTime);
  }
}

// Function to execute the Shortest Job First (SJF) algorithm
void sjf(Process processes[]) {
  // Sort processes by burst time
  qsort(processes, NUM_PROCESSES, sizeof(Process), compareArrivalTime);

  // Execute processes
  int currentTime = 0;
  for (int i = 0; i < NUM_PROCESSES; i++) {
    Process *process = &processes[i];
    printf("Process %d: ", i + 1);
    currentTime += process->burstTime;
    printf("Arrival time: %d\n", process->arrivalTime);
    printf("Burst time: %d\n", process->burstTime);
    printf("Start time: %d\n", currentTime - process->burstTime);
    printf("End time: %d\n\n", currentTime);
  }
}

// Function to execute the Priority Scheduling algorithm
void priority(Process processes[]) {
  // Sort processes by priority
  qsort(processes, NUM_PROCESSES, sizeof(Process), comparePriority);

  // Execute processes
  int currentTime = 0;
  for (int i = 0; i < NUM_PROCESSES; i++) {
    Process *process = &processes[i];
    printf("Process %d: ", i + 1);
    currentTime += process->burstTime;
    printf("Arrival time: %d\n", process->arrivalTime);
    printf("Burst time: %d\n", process->burstTime);
    printf("Priority: %d\n", process->priority);
    printf("Start time: %d\n", currentTime - process->burstTime);
    printf("End time: %d\n\n", currentTime);
  }
}

int main() {
  // Initialize processes
  Process processes[] = {
      {0, 5, 3},
      {1, 7, 2},
      {2, 3, 5},
      {3, 4, 1},
      {4, 6, 4},
  };

  // Execute FCFS algorithm
  printf("FCFS:\n");
  fcfs(processes);

  // Execute SJF algorithm
  printf("SJF:\n");
  sjf(processes);

  // Execute Priority algorithm
  printf("Priority:\n");
  priority(processes);

  return 0;
}