//GEMINI-pro DATASET v1.0 Category: Planet Gravity Simulation ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <GL/glut.h>

#define NUM_PLANETS 10
#define G 6.674e-11

typedef struct {
    double mass;
    double radius;
    double x, y, z;
    double vx, vy, vz;
} planet;

planet planets[NUM_PLANETS];

void init() {
    srand(time(NULL));
    for (int i = 0; i < NUM_PLANETS; i++) {
        planets[i].mass = (rand() % 1000) / 100.0;
        planets[i].radius = (rand() % 100) / 10.0;
        planets[i].x = (rand() % 1000) - 500;
        planets[i].y = (rand() % 1000) - 500;
        planets[i].z = (rand() % 1000) - 500;
        planets[i].vx = (rand() % 100) / 10.0;
        planets[i].vy = (rand() % 100) / 10.0;
        planets[i].vz = (rand() % 100) / 10.0;
    }
}

void display() {
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();
    gluLookAt(0, 0, 500, 0, 0, 0, 0, 1, 0);
    for (int i = 0; i < NUM_PLANETS; i++) {
        glPushMatrix();
        glTranslatef(planets[i].x, planets[i].y, planets[i].z);
        glutSolidSphere(planets[i].radius, 20, 20);
        glPopMatrix();
    }
    glutSwapBuffers();
}

void update() {
    for (int i = 0; i < NUM_PLANETS; i++) {
        for (int j = i + 1; j < NUM_PLANETS; j++) {
            double dx = planets[i].x - planets[j].x;
            double dy = planets[i].y - planets[j].y;
            double dz = planets[i].z - planets[j].z;
            double r = sqrt(dx * dx + dy * dy + dz * dz);
            double f = G * planets[i].mass * planets[j].mass / (r * r);
            planets[i].vx += f * dx / r;
            planets[i].vy += f * dy / r;
            planets[i].vz += f * dz / r;
            planets[j].vx -= f * dx / r;
            planets[j].vy -= f * dy / r;
            planets[j].vz -= f * dz / r;
        }
        planets[i].x += planets[i].vx;
        planets[i].y += planets[i].vy;
        planets[i].z += planets[i].vz;
    }
    glutPostRedisplay();
}

void main(int argc, char** argv) {
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
    glutInitWindowSize(800, 600);
    glutInitWindowPosition(100, 100);
    glutCreateWindow("Planet Gravity Simulation");
    init();
    glutDisplayFunc(display);
    glutIdleFunc(update);
    glutMainLoop();
}