//GEMINI-pro DATASET v1.0 Category: Chess engine ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 8

typedef struct {
    int x;
    int y;
} Position;

typedef struct {
    char piece;
    Position position;
} Piece;

typedef struct {
    Piece board[BOARD_SIZE][BOARD_SIZE];
} Board;

void initialize_board(Board *board) {
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            board->board[i][j].piece = ' ';
        }
    }

    // Place the white pieces
    for (int i = 0; i < BOARD_SIZE; i++) {
        board->board[1][i].piece = 'p';
    }
    board->board[0][0].piece = 'r';
    board->board[0][1].piece = 'n';
    board->board[0][2].piece = 'b';
    board->board[0][3].piece = 'q';
    board->board[0][4].piece = 'k';
    board->board[0][5].piece = 'b';
    board->board[0][6].piece = 'n';
    board->board[0][7].piece = 'r';

    // Place the black pieces
    for (int i = 0; i < BOARD_SIZE; i++) {
        board->board[6][i].piece = 'P';
    }
    board->board[7][0].piece = 'R';
    board->board[7][1].piece = 'N';
    board->board[7][2].piece = 'B';
    board->board[7][3].piece = 'Q';
    board->board[7][4].piece = 'K';
    board->board[7][5].piece = 'B';
    board->board[7][6].piece = 'N';
    board->board[7][7].piece = 'R';
}

void print_board(Board *board) {
    printf("  a b c d e f g h\n");
    printf("8");
    for (int i = 0; i < BOARD_SIZE; i++) {
        printf(" %c", board->board[7][i].piece);
    }
    printf("\n");
    for (int i = 6; i >= 0; i--) {
        printf("%d", i + 1);
        for (int j = 0; j < BOARD_SIZE; j++) {
            printf(" %c", board->board[i][j].piece);
        }
        printf("\n");
    }
}

int main() {
    Board board;
    initialize_board(&board);
    print_board(&board);

    return 0;
}