//GEMINI-pro DATASET v1.0 Category: System administration ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>

int main(int argc, char *argv[]) {
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <file_to_create>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    char *file_name = argv[1];

    // Create a new file descriptor for the file to be created
    int fd = open(file_name, O_WRONLY | O_CREAT | O_EXCL, S_IRUSR | S_IWUSR);
    if (fd == -1) {
        perror("open");
        exit(EXIT_FAILURE);
    }

    // Write some data to the file
    const char *data = "Hello, world!\n";
    ssize_t bytes_written = write(fd, data, strlen(data));
    if (bytes_written == -1) {
        perror("write");
        exit(EXIT_FAILURE);
    }

    // Close the file descriptor
    if (close(fd) == -1) {
        perror("close");
        exit(EXIT_FAILURE);
    }

    // Check if the file was created successfully
    struct stat file_info;
    if (stat(file_name, &file_info) == -1) {
        perror("stat");
        exit(EXIT_FAILURE);
    }

    if (!S_ISREG(file_info.st_mode)) {
        fprintf(stderr, "%s is not a regular file\n", file_name);
        exit(EXIT_FAILURE);
    }

    printf("File %s created successfully\n", file_name);

    return EXIT_SUCCESS;
}